function [snr_op, SNR_t_op, Spect,FID_op,fshift_ppm,expt,AQ_op] = one_pulse_calc(directory,op_num,signal_bound,noise_bound)
B = rbnmr([directory,filesep,num2str(op_num)]);
Y = B.Data;
fshift_ppm = B.XAxis;

% importing parameters from Bruker files
SW_h = B.Acqus.SW_h;
TD_op = B.Acqus.TD;
NS_op = B.Acqus.NS;
D1_op = B.Acqus.D(2);
AQ_op = (1:TD_op/2)*1/SW_h;

% Experiment time for one pulse
expt = NS_op*D1_op*AQ_op(end);

fileID = fopen([directory,filesep,num2str(op_num),filesep,'fid'],'r');
C = fread(fileID,'int32');  % read raw data from ser file.
fclose(fileID);
D = reshape(C,2,[]);
FID_op = D(1,:) + 1i*D(2,:);

Spect = real(Y);
[snr_op,SNR_t_op] = SNR_calc(Y,fshift_ppm,expt,signal_bound,noise_bound);